/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ToolAnimationRenderer {
    private static ToolAnimationRenderer instance;
    private final Map<BlockPos, Animation> animationMap = new HashMap<BlockPos, Animation>();

    public static ToolAnimationRenderer get() {
        if (instance == null) {
            instance = new ToolAnimationRenderer();
        }
        return instance;
    }

    private ToolAnimationRenderer() {
    }

    public void tick() {
        this.animationMap.entrySet().removeIf(entry -> {
            ((Animation)entry.getValue()).tick();
            return ((Animation)entry.getValue()).isFinished();
        });
    }

    public void render(Level level, PoseStack poseStack, MultiBufferSource.BufferSource source, float partialTick) {
        this.animationMap.forEach((pos, animation) -> {
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)animation.pos);
            animation.render(level, poseStack, source, light, partialTick);
        });
    }

    public void playSpatulaAnimation(BlockPos dispenserPos, Direction direction) {
        this.animationMap.put(dispenserPos, new Animation(Tool.SPATULA, dispenserPos.m_121945_(direction), direction));
    }

    public void playKnifeAnimation(BlockPos dispenserPos, Direction direction) {
        this.animationMap.put(dispenserPos, new Animation(Tool.KNIFE, dispenserPos.m_121945_(direction), direction));
    }

    private static class Animation {
        private final ItemStack stack;
        private final Tool tool;
        private final BlockPos pos;
        private final Direction direction;
        private int time;

        public Animation(Tool tool, BlockPos pos, Direction direction) {
            this.stack = tool.stack.get();
            this.tool = tool;
            this.pos = pos;
            this.direction = direction;
        }

        private boolean isFinished() {
            return this.time >= this.tool.animationTime;
        }

        private void tick() {
            if (this.time < this.tool.animationTime) {
                ++this.time;
            }
        }

        public void render(Level level, PoseStack poseStack, MultiBufferSource.BufferSource source, int light, float partialTick) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_(), (double)this.pos.m_123343_() + 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(-1.5707964f * (float)this.direction.m_122416_()));
            this.tool.transform.accept(poseStack, Float.valueOf((float)this.time + partialTick));
            Minecraft.m_91087_().m_91291_().m_269128_(this.stack, ItemDisplayContext.NONE, light, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)source, level, 0);
            poseStack.m_85849_();
        }
    }

    private static enum Tool {
        SPATULA(() -> new ItemStack((ItemLike)ModItems.SPATULA.get()), 6, (poseStack, time) -> {
            poseStack.m_85837_(0.0, 0.375, 0.0);
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(0.7853982f));
            if (time.floatValue() >= 2.0f) {
                poseStack.m_252781_(Axis.f_252495_.m_252961_(0.7853982f * ((time.floatValue() - 2.0f) / 2.0f)));
            }
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_85837_(0.0, 0.0, -0.5 + (double)Mth.m_14031_((float)(time.floatValue() / 6.0f)) * 0.375);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(0.7853982f));
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        }),
        KNIFE(() -> new ItemStack((ItemLike)ModItems.KNIFE.get()), 4, (poseStack, time) -> {
            poseStack.m_85837_(0.0, 0.375, 0.0);
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            if (time.floatValue() >= 2.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252961_(0.7853982f * ((time.floatValue() - 2.0f) / 2.0f)));
            }
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_85837_(0.0, 0.0, -0.5 + (double)(time.floatValue() / 4.0f) * 0.375);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
            poseStack.m_252781_(Axis.f_252392_.m_252961_(1.5707964f));
            poseStack.m_252781_(Axis.f_252403_.m_252961_(0.7853982f));
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        });

        private final Supplier<ItemStack> stack;
        private final int animationTime;
        private final BiConsumer<PoseStack, Float> transform;

        private Tool(Supplier<ItemStack> stack, int animationTime, BiConsumer<PoseStack, Float> transform) {
            this.stack = stack;
            this.animationTime = animationTime;
            this.transform = transform;
        }
    }
}

